package msgcrypto

import (
	"bytes"
	"encoding/binary"
	"strconv"
	"strings"
	"time"
)

type DTMsgCrypto struct {
	Token          string
	EncodingAESKey string
	DTAppKey       string
	// BKey           []byte
	// Block          cipher.Block
}

type RespJSON struct {
	// Eventtype string `json:"EventType"`
	Encrypt      string `json:"encrypt"`
	Msgsignature string `json:"msg_signature"`
	Nonce        string `json:"nonce"`
	Timestamp    string `json:"timeStamp"`
}

func NewDTCrypto(token, encodingAESKey, dtappKey string) *DTMsgCrypto {
	// fmt.Println(len(encodingAESKey))
	// if len(encodingAESKey) != int(43) {
	// 	panic("Invalid AES key")
	// }
	// bkey, err := base64.StdEncoding.DecodeString(encodingAESKey + "=")
	// if err != nil {
	// 	panic(err.Error())
	// }
	// block, err := aes.NewCipher(bkey)
	// if err != nil {
	// 	panic(err.Error())
	// }
	// c := DTMsgCrypto{
	// 	Token:          token,
	// 	EncodingAESKey: encodingAESKey,
	// 	DTAppKey:       dtappKey,
	// 	BKey:           bkey,
	// 	Block:          block,
	// }
	// return &c
	return &DTMsgCrypto{Token: token, EncodingAESKey: (encodingAESKey + "="), DTAppKey: dtappKey}

}

func (self *DTMsgCrypto) DecryptMsg(msg_signature, timestamp, nonce, encrypt string) ([]byte, *CryptError) {
	signature := calSignature(self.Token, timestamp, nonce, encrypt)

	if strings.Compare(signature, msg_signature) != 0 {
		return nil, NewCryptError(ValidateSignatureError, "signature not equal")
	}

	plaintext, crypt_err := cbcDecrypter(encrypt, self.EncodingAESKey)
	if nil != crypt_err {
		return nil, crypt_err
	}

	_, _, msg, receiver_id, crypt_err := parsePlainText(plaintext)
	if nil != crypt_err {
		return nil, crypt_err
	}

	if len(self.DTAppKey) > 0 && strings.Compare(string(receiver_id), self.DTAppKey) != 0 {
		return nil, NewCryptError(ValidateCorpidError, "receiver_id is not equil")
	}

	return msg, nil
}

func (self *DTMsgCrypto) EncryptMsg(msg string, jsondict *RespJSON) *CryptError {
	rand_str := randString(16)
	var buffer bytes.Buffer
	buffer.WriteString(rand_str)

	msg_len_buf := make([]byte, 4)
	binary.BigEndian.PutUint32(msg_len_buf, uint32(len(msg)))
	buffer.Write(msg_len_buf)
	buffer.WriteString(msg)
	buffer.WriteString(self.DTAppKey)

	tmp_ciphertext, err := cbcEncrypter(buffer.String(), self.EncodingAESKey)
	if err != nil {
		return err
	}
	ciphertext := string(tmp_ciphertext)

	// signature := calSignature(self.Token, timestamp, nonce, ciphertext)

	jsondict.Encrypt = ciphertext
	jsondict.Nonce = randString(16)
	jsondict.Timestamp = strconv.FormatInt(time.Now().Unix(), 10)
	jsondict.Msgsignature = calSignature(self.Token, jsondict.Timestamp, jsondict.Nonce, jsondict.Encrypt)

	return nil
}
