package handlers

import (
	"encoding/json"
	"fmt"
	"net/http"
	"os"
	"tjai/gdapi/msgcrypto"

	"github.com/gin-gonic/gin"
)

type DTEvent struct {
	Eventtype string `json:"EventType"`
}

type DecodedMsg struct {
	Nonce  uint32 `json:"random"`
	Msglen uint32 `json:"msg_len"`
	Msg    string `json:"msg"`
	CorpID string `json:"CorpID"`
}

type DTMsg struct {
	Encrypt string `json:"encrypt"`
}

func getDTAuth() (string, string, string) {
	token := os.Getenv("TOKEN")
	dtappkey := os.Getenv("DTAPPKEY")
	encodingAeskey := os.Getenv("ENCODINGAESKEY")
	return token, dtappkey, encodingAeskey
}

func DTEventHandler(ctx *gin.Context) {
	token, dtappkey, encodingAeskey := getDTAuth()
	dtcpt := msgcrypto.NewDTCrypto(token, encodingAeskey, dtappkey)
	query := ctx.Request.URL.Query()
	// var dtmsg WecomMsg
	dtmsg := DTMsg{}

	// print the url query 'key => value' pairs
	for key, val := range query {
		fmt.Println("key:", key, "=>", "value:", val)
	}

	signatures, sigfound := query["signature"]
	timestamps, tsfound := query["timestamp"]
	nonces, ncfound := query["nonce"]

	if !sigfound || !tsfound || !ncfound {
		fmt.Println("Invalid query.")
		ctx.IndentedJSON(http.StatusBadRequest, gin.H{
			"message": "Invalid query",
			"success": false,
		})
		return
	}

	if err := ctx.BindJSON(&dtmsg); err != nil {
		fmt.Println("Invalid request:", err)
		ctx.IndentedJSON(http.StatusUnauthorized, gin.H{
			"message": "Invalid event type",
			"success": false,
		})
		return
	}

	msg, dcrterr := dtcpt.DecryptMsg(signatures[0], timestamps[0], nonces[0], string(dtmsg.Encrypt))
	if dcrterr != nil {
		fmt.Println("DecryptMsg fail", dcrterr)
		ctx.IndentedJSON(http.StatusBadRequest, gin.H{
			"message": "Decoding failed",
			"success": false,
		})
		return
	}
	fmt.Printf("Decoded JSON:\n%s\n", string(msg))

	dtevent := DTEvent{}
	if err := json.Unmarshal(msg, &dtevent); err != nil {
		fmt.Println("Unmarshal json message fail:", err)
		ctx.IndentedJSON(http.StatusBadRequest, gin.H{
			"message": "Unmarshal failed",
			"success": false,
		})
		return
	}
	fmt.Println("Received event:", string(dtevent.Eventtype))

	// check_url handler
	if dtevent.Eventtype == "check_url" {
		respjson := msgcrypto.RespJSON{}
		dtcpt.EncryptMsg("success", &respjson)
		fmt.Println("encrypted:", respjson.Encrypt)
		ctx.IndentedJSON(http.StatusOK, respjson)
		return
	}
}
