package handlers

import (
	"github.com/golang-jwt/jwt/v4"
	"go.mongodb.org/mongo-driver/bson/primitive"
)

type tokenAuthReq struct {
	Name     string `json:"name"`
	Password string `json:"password"`
}

type registerReq struct {
	Username string `json:"username"`
	Password string `json:"password"`
	Email    string `json:"email"`
	Regcode  string `json:"regcode"`
}

type accesstoken struct {
	Message string `json:"message"`
	Success bool   `json:"success"`
	Token   string `json:"token"`
}

type usernameClaims struct {
	Name string `json:"name"`
	jwt.RegisteredClaims
}

type userAccount struct {
	Name     string `json:"name" bson:"name"`
	Email    string `json:"email" bson:"email"`
	Corp     string `json:"corp" bson:"corp"`
	Password string `json:"password" bson:"password"`
}

type userDoc struct {
	Id       primitive.ObjectID `json:"_id,omitempty" bson:"_id,omitempty"`
	Name     string             `json:"name" bson:"name"`
	Email    string             `json:"email" bson:"email"`
	Corp     string             `json:"corp" bson:"corp"`
	Password string             `json:"password" bson:"password"`
}

type coordinate struct {
	Latitude  float64 `json:"latitude" bson:"latitude"`
	Longitude float64 `json:"longitude" bson:"longitude"`
	Altitude  float64 `json:"altitude" bson:"altitude"`
}

type deviceInfoReq struct {
	Deviceid     string     `json:"deviceid" bson:"deviceid"`
	Serialnumber string     `json:"serialnumber" bson:"serialnumber"`
	Coordinate   coordinate `json:"coordinate" bson:"coordinate"`
	User         string     `json:"user" bson:"user"`
}

type deviceInfoDoc struct {
	Id           primitive.ObjectID `json:"_id,omitempty" bson:"_id,omitempty"`
	Deviceid     string             `json:"deviceid" bson:"deviceid"`
	Serialnumber string             `json:"serialnumber,omitempty" bson:"serialnumber,omitempty"`
	Coordinate   coordinate         `json:"coordinate,omitempty" bson:"coordinate,omitempty"`
	User         primitive.ObjectID `json:"user,omitempty" bson:"user,omitempry"`
	UpdatedAt    primitive.DateTime `json:"updatedAt,omitempty" bson:"updatedAt,omitempty"`
}

type sensorInfoReq struct {
	Name            string `json:"name" bson:"name"`
	Code            string `json:"code" bson:"code"`
	Type            string `json:"type" bson:"type"`
	Upperthreshold  int32  `json:"upperthreshold" bson:"upperthreshold"`
	Bottomthreshold int32  `json:"bottomthreshold" bson:"bottomthreshold"`
	Device          string `json:"device" bson:"device"`
}

type sensorInfoDoc struct {
	Id              primitive.ObjectID `bson:"_id,omitempty"`
	Code            string             `bson:"code"`
	Name            string             `bson:"name"`
	Type            string             `bson:"type"`
	Upperthreshold  int32              `bson:"upperthreshold"`
	Bottomthreshold int32              `bson:"bottomthreshold"`
	User            primitive.ObjectID `bson:"user"`
	Device          primitive.ObjectID `bson:"device"`
	CreatedAt       primitive.DateTime `bson:"createdAt,omitempty"`
	UpdatedAt       primitive.DateTime `bson:"updatedAt,omitempty"`
}

type sensordataReq struct {
	Sensorinfo    string `json:"sensorinfo" bson:"sensorinfo"`
	Concentration int32  `json:"concentration" bson:"concentration"`
	Unit          string `json:"unit" bson:"unit"`
}

type sensordataDoc struct {
	Sensorinfo    primitive.ObjectID `json:"sensorinfo" bson:"sensorinfo"`
	Concentration int32              `json:"concentration" bson:"concentration"`
	Unit          string             `json:"unit" bson:"unit"`
	IsNormal      bool               `json:"isNormal" bson:"isNormal"`
}

type rtDataReq struct {
	Device    string `json:"device" bson:"device"`
	Pdev      int32  `json:"pdev" bson:"pdev,omitempty"`
	Startfrom int64  `json:"startfrom"`
	End       int64  `json:"end"`
}

type realtimeDataReq struct {
	Updatetime int64           `json:"updatetime" bson:"updatetime"`
	Device     string          `json:"device" bson:"device"`
	Sensordata []sensordataReq `json:"sensordata" bson:"sensordata"`
}

type rtDataDoc struct {
	Sensordata []struct {
		Sensorinfo struct {
			Code            string `json:"code" bson:"code"`
			Name            string `json:"name" bson:"name"`
			Type            string `json:"type" bson:"type"`
			Upperthreshold  int32  `json:"upperthreshold" bson:"upperthreshold"`
			Bottomthreshold int32  `json:"bottomthreshold" bson:"bottomthreshold"`
		} `json:"sensorinfo" bson:"sensorinfo"`
		Concentration int32  `json:"concentration" bson:"concentration"`
		Unit          string `json:"unit" bson:"unit"`
		IsNormal      bool   `json:"isNormal" bson:"isNormal"`
	} `json:"sensordata" bson:"sensordata"`
	Pdev   int32 `json:"pdev" bson:"pdev,omitempty"`
	Device struct {
		Deviceid   string     `json:"deviceid" bson:"deviceid"`
		Coordinate coordinate `json:"coordinate" bson:"coordinate"`
	} `json:"device" bson:"device"`
	CreatedAt primitive.DateTime `json:"createdAt,omitempty" bson:"createdAt,omitempty"`
}

type realtimeDataDoc struct {
	Id         primitive.ObjectID `bson:"_id,omitempty"`
	Sensordata []sensordataDoc    `bson:"sensordata"`
	Pdev       int32              `bson:"pdev,omitempty"`
	Device     primitive.ObjectID `bson:"device"`
	User       primitive.ObjectID `bson:"user"`
	CreatedAt  primitive.DateTime `bson:"createdAt,omitempty"`
	UpdatedAt  primitive.DateTime `bson:"updatedAt,omitempty"`
}

type cameraSourceReq struct {
	Cameraid string `json:"cameraid" bson:"cameraid"`
	Url      string `json:"url" bson:"url"`
	Device   string `json:"device" bson:"device"`
}

type cameraSourceDoc struct {
	Id       primitive.ObjectID `bson:"_id,omitempty"`
	Cameraid string             `bson:"cameraid"`
	Url      string             `bson:"url"`
	User     primitive.ObjectID `bson:"user"`
	Device   primitive.ObjectID `bson:"device"`
}

type recordReq struct {
	Device  string `json:"device"`
	Date    string `json:"date"`
	RecFile string `json:"recFile"`
}

type staffReq struct {
	Device   string `json:"device" bson:"device"`
	Number   string `json:"workNo" bson:"workNo"`
	Name     string `json:"name" bson:"name"`
	Captured bool   `json:"captured" bson:"captured"`
}

type staffDoc struct {
	Device   primitive.ObjectID `bson:"device"`
	User     primitive.ObjectID `bson:"user"`
	Number   string             `bson:"workNo"`
	Name     string             `bson:"name"`
	Captured bool               `bson:"captured"`
}

type offerReq struct {
	Device string `json:"device"`
	Offer  string `json:"offer"`
}

type odResultReq struct {
	Device  string            `json:"device"`
	Objects map[string]uint32 `json:"objects"`
}

type odResultDoc struct {
	User      primitive.ObjectID `bson:"user" json:"user"`
	Device    primitive.ObjectID `bson:"device" json:"device"`
	Objects   map[string]uint32  `bson:"objects" json:"objects"`
	CreatedAt primitive.DateTime `bson:"createdAt,omitempty" json:"createdAt,omitempty"`
	UpdatedAt primitive.DateTime `bson:"updatedAt,omitempty" json:"updatedAt,omitempty"`
}

type odResQueryReq struct {
	Device    string `json:"device" bson:"device"`
	Startfrom int64  `json:"startfrom"`
	End       int64  `json:"end"`
}
